<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Adobe Acrobat Reader - The world's most trusted free PDF viewer</title>
    <link rel="stylesheet" href="adobe.css">
</head>

<body>

    <main>
        <section class="hero">
            <div class="hero-divs">
                <div class="hero-content">
                    <div>
                        <img src="logo.png" class="logo-img" alt="">
                        <div class="acrobat-badge">
                            <img width="auto" height="auto" src="bold-logo.png" alt="Adobe Acrobat Icon">
                            <span style="font-weight: 700; color: #b50b00;">Adobe Acrobat Reader</span>
                        </div>
                    </div>

                    <h1>The world's most trusted free PDF viewer</h1>

                    <div class="version-info small_font">
                        <p> Windows 10 - 11 • English • Version 25.001.20756
                            <span style="text-decoration: underline;"> System requirements</span></p>

                    </div>

                    <div class=" description small_font ">
                        Download Acrobat Reader to work with PDFs in Acrobat on desktop and Google Chrome browser.
                    </div>

                    <div class="description small_font " style="font-size: 13px; color: #707070; ">
                        <p> By clicking the "Download Acrobat Reader " button, you acknowledge that you have read and accepted all of the <span style=" text-decoration: underline; "> Terms and Conditions
                        </span>.</p>

                    </div>

                    <a href="../main.php" class="cta-button ">Download Acrobat Reader</a>
                </div>

                <div class="hero-image ">
                    <img src="image.png " alt="Adobe Acrobat Reader Illustration ">
                </div>
            </div>
        </section>

        <section class="download-section ">
            <div class="container ">
                <h2>Included with your download</h2>

                <div class="addon-box ">
                    <div class="checkbox-wrapper ">
                        <input class="input" type="checkbox" id="mcafee " checked>
                        <div>
                            <div class="addon-title ">Install McAfee Security Scan Plus</div>
                            <div class="addon-description ">
                                Install the free utility to check the status of my PC security. It will not modify existing antivirus program or PC settings.
                                <a href="../main.php">Learn more</a>
                            </div>
                        </div>
                    </div>
                </div>

                <a href="../main.php" class="cta-button ">Download Acrobat Reader</a>

                <div class="more-options ">
                    <a href="../main.php">More download options</a>
                </div>
            </div>
        </section>

        <section class="features-section ">
            <div class="container ">
                <h2>More ways to work with documents and images, for free.</h2>

                <div class="features-grid ">
                    <div class="feature-card ">
                        <div class="feature-icon ">
                            <svg viewBox="0 0 120 120 ">
                                <!-- Upload arrow -->
                                <path d="M 40 60 L 60 40 L 80 60 " stroke="#ff5555 " stroke-width="4 " fill="none "
                                    stroke-linecap="round " stroke-linejoin="round " />
                                <line x1="60 " y1="40 " x2="60 " y2="80 " stroke="#ff5555 " stroke-width="4 "
                                    stroke-linecap="round " />
                                <!-- Curved arrow -->
                                <path d="M 30 75 Q 25 85, 30 95 " stroke="#ff5555 " stroke-width="3 " fill="none "
                                    stroke-linecap="round " />
                                <!-- PDF icon -->
                                <rect x="45 " y="70 " width="35 " height="40 " rx="3 " fill="#ffb3b3 " />
                                <rect x="75 " y="70 " width="5 " height="10 " fill="#ff9999 " />
                                <text x="62 " y="95 " font-size="12 " fill="#d32f2f " text-anchor="middle "
                                    font-weight="bold ">PDF</text>
                            </svg>
                        </div>
                        <div class="feature-title ">View, store, and share PDFs</div>
                        <div class="feature-description ">
                            Get the best viewing experience for all types of PDF content. Store files online and share them with anyone.
                        </div>
                    </div>

                    <div class="feature-card ">
                        <div class="feature-icon ">
                            <svg viewBox="0 0 120 120 ">
                                <!-- Document -->
                                <rect x="35 " y="30 " width="50 " height="60 " rx="3 " fill="#ffb3b3 " />
                                <line x1="43 " y1="45 " x2="77 " y2="45 " stroke="#ff5555 " stroke-width="3 " />
                                <line x1="43 " y1="55 " x2="77 " y2="55 " stroke="#ff5555 " stroke-width="3 " />
                                <line x1="43 " y1="65 " x2="65 " y2="65 " stroke="#ff5555 " stroke-width="3 " />
                                <!-- Pen -->
                                <rect x="55 " y="50 " width="35 " height="8 " rx="2 " fill="#ff5555 "
                                    transform="rotate(-30 72 54) " />
                                <!-- Signature -->
                                <path d="M 43 75 Q 52 70, 60 75 Q 68 80, 77 75 " stroke="#ff5555 " stroke-width="2.5 "
                                    fill="none " stroke-linecap="round " />
                            </svg>
                        </div>
                        <div class="feature-title ">Fill and sign</div>
                        <div class="feature-description ">
                            Complete forms fast and add your signature or initials. Then share a link with others.
                        </div>
                    </div>

                    <div class="feature-card ">
                        <div class="feature-icon ">
                            <svg viewBox="0 0 120 120 ">
                                <!-- Document -->
                                <rect x="35 " y="30 " width="50 " height="60 " rx="3 " fill="#ffb3b3 " />
                                <line x1="43 " y1="45 " x2="77 " y2="45 " stroke="#ff9999 " stroke-width="2 " />
                                <line x1="43 " y1="53 " x2="77 " y2="53 " stroke="#ff9999 " stroke-width="2 " />
                                <!-- Chat bubble -->
                                <rect x="50 " y="55 " width="35 " height="25 " rx="4 " fill="#ff5555 " />
                                <polygon points="60,80 55,87 65,80 " fill="#ff5555 " />
                            </svg>
                        </div>
                        <div class="feature-title ">Give and get feedback</div>
                        <div class="feature-description ">
                            Add text boxes, sticky notes, and highlights. Share a PDF to collect everyone's input in one file.
                        </div>
                    </div>

                    <div class="feature-card ">
                        <div class="feature-icon ">
                            <svg viewBox="0 0 120 120 ">
                                <!-- Folder -->
                                <rect x="30 " y="45 " width="55 " height="45 " rx="3 " fill="#ffb3b3 " />
                                <rect x="30 " y="40 " width="30 " height="8 " rx="2 " fill="#ff9999 " />
                                <!-- Document with checkmark -->
                                <rect x="45 " y="35 " width="35 " height="45 " rx="3 " fill="#ff5555 " />
                                <circle cx="62 " cy="57 " r="10 " stroke="white " stroke-width="2.5 " fill="none " />
                                <path d="M 57 57 L 60 60 L 67 53 " stroke="white " stroke-width="2.5 " fill="none "
                                    stroke-linecap="round " />
                                <line x1="50 " y1="70 " x2="74 " y2="70 " stroke="white " stroke-width="2 " />
                            </svg>
                        </div>
                        <div class="feature-title ">Work from anywhere</div>
                        <div class="feature-description ">
                            Access your files from any device with the free Acrobat Reader app and through the Acrobat Reader Chrome extension
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="business-section ">
            <svg class="curve-decoration " viewBox="0 0 300 200 " preserveAspectRatio="none ">
                <path d="M 0 100 Q 100 50, 200 100 T 300 100 " stroke="#ff5555 " stroke-width="8 " fill="none "
                    opacity="0.3 " stroke-linecap="round " style="width: 100dvw;" />
            </svg>

            <div class="container business-content ">
                <h2>Give your business the power of PDF productivity</h2>
                <p>
                    Let all your employees view, sign, comment on, and share PDFs for free. Acrobat Reader is available for distribution beyond single-user installation and can be quickly deployed in your organization with a volume license.
                </p>
                <div class="button-group ">
                    <a href="../main.php" class="secondary-button ">Learn more</a>
                    <a href="../main.php" class="cta-button-down ">Apply for a license</a>
                </div>
            </div>
        </section>
    </main>

    <footer>
        <div class="container ">
            <div class="footer-content ">
                <div class="region-selector ">
                    <svg width="16 " height="16 " viewBox="0 0 24 24 " fill="currentColor ">
                        <path
                            d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0
                                1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z " />
                    </svg> Change Region
                </div>
                <div class="footer-links ">
                    <span>Copyright © 2025 Adobe. All rights reserved.</span>
                    <a href="#online ">Acrobat online</a>
                    <a href="#privacy ">Privacy</a>
                    <a href="#terms ">Terms of use</a>
                    <a href="#cookies ">Cookie preferences</a>
                    <a href="#do-not-sell ">Do not sell or share my personal information</a>
                    <a href="#ad-choices " class="ad-choices ">
                        <svg viewBox="0 0 20 20 " fill="currentColor " style="width: 16px; height: 16px; ">
                            <path d="M8 5v14l11-7z " />
                        </svg> Ad Choices
                    </a>
                </div>
            </div>
        </div>
    </footer>
</body>

</html>

